
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_Data.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "SST_TST.h"
#if TST_USE_SPECIAL_DATA_MODULE
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_SpecialDataOpAES        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of an AES symmetric key.
 *  
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Create a new AES shared key authenticator by calling: SST_ AuthenticatorAESSharedSecretCreate.
 *    4.    Open the authenticator by calling:
 *          i.      SST_AuthenticatorChallengeGet 
 *          ii.      CRYS_AES (Encrypt the challenge using the AES key)
 *          iii.  SST_AuthenticationOpen.
 *    5.  Close the transaction by calling: SST_TransactionClose.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new AES #1 key by calling: SST_AESKeyGenerate.
 *    8.  Read the generated AES key #1 by calling: SST_AESKeyRead.
 *    9.  Insert an AES #2 key to the SST by calling: SST_AESKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted AES key #2 by calling: SST_AESKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Encrypt plain text by using AES key #1 and calling: CRYS_SST_AES.
 *    13.  Decrypt the received cipher text using AES key #2 by calling: CRYS_SST_AES and compare to the original plain text.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the AES keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SST_TST_ATP_SpecialDataOpAES ( void )
{ 
   /********* TST Variables Definitions ************/
    int                         TST_index,TST_HandleType;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_SpecialDataOpAES";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle,TST_AESKeyHandle1,TST_AESKeyHandle2;
    SSTChallengeId_t            TST_ChallengeId;
    SSTDataType_t               TST_AESKeyData = TST_AESKEY_OBJECT;
    CRYS_AES_EncryptMode_t      TST_CRYS_AES_EncryptMode;
  DxError_t                TST_Status = DX_FAILURE;
    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_SpecialDataOpAES Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_SST_TST_ATP_SpecialDataOpAESTests ; TST_index++) /*To run on all test vectors*/
        {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
                TST_AESKeyHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_AESKeyHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = TST_TEST_DEFINED_HENDLE;
                TST_AESKeyHandle1.objId = TST_TEST_DEFINED_HENDLE_2;
                TST_AESKeyHandle2.objId = TST_TEST_DEFINED_HENDLE_3;

            }

            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,"\n"));

            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new AES shared key authenticator */
            /*-------------------------------------------*/
            TST_Status = SST_AuthenticatorAESSharedSecretCreate(TST_TransactionId,
                                                               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AuthenticatorAESKey,
                                                               SST_KEY_TYPE_AES_128_BIT,
                                                               &TST_AuthHandle,
                                                               TST_Workspace,
                                                               TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorAESSharedSecretCreate",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Open the authentication */
            /*-------------------------*/
            /* Get the challenge*/
            TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuff,
                                                      TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuffSize,  
                                                      &TST_ChallengeId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Encrypt the challenge using the AES key */
            TST_Status = CRYS_AES(DX_NULL,
                                 TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AuthenticatorAESKey,
                                 CRYS_AES_Key128BitSize,
                                 CRYS_AES_Encrypt,
                                 CRYS_AES_ECB_mode,
                                 TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuff,
                                 TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuffSize,
                                 TST_ATP_SpecialDataOpAESTestData[TST_index].TST_EncChallengeBuff);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_AES",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


      /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Open the authenticator */
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_EncChallengeBuff,
                                               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuffSize,
                                               TST_ChallengeId,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);               
                                               
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - AES",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


      /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Create a new AES key #1 */
            /*-------------------------*/
            TST_Status = SST_AESKeyGenerate(TST_TransactionId,
                                           TST_SessionId,
                                           TST_AuthHandle,                                
                                           TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType1,
                                           TST_AESKeyData,
                                           &TST_AESKeyHandle1,
                                           TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyGenerate",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify the type of AES key #1 */
            /*-------------------------------*/
            TST_Status = SST_AESKeyRead(TST_SessionId,
                                       TST_AESKeyHandle1,   
                                       TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKey2,
                                       &TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyRead - Get key type",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            if (TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType2 != TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType1)
                TST_Status = DX_FALSE;

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Validate key type - AES",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  


            /* Insert AES Key #2 */
            /*-------------------*/
            TST_Status = SST_AESKeyInsert(TST_TransactionId,
                                         TST_SessionId,
                                         TST_AuthHandle,                                                               
                                         TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKey2,
                                         TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType2,
                                         TST_AESKeyData,
                                         &TST_AESKeyHandle2,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyInsert - Key #2",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Read AES key #2 */
            /*-----------------*/
            TST_Status = SST_AESKeyRead(TST_SessionId,
                                       TST_AESKeyHandle2,   
                                       TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyTemp,
                                       &TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyTypeTemp,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyRead #2",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Compare the retrieved key to inserted one */
      /*-------------------------------------------*/
         if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKey2,
                TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyTemp,
                TST_ATP_SpecialDataOpAESTestData[TST_index].TST_KeySizeInBytes))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - keys",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Encrypt a block of data using key #1 */
            /*--------------------------------------*/
            TST_Status = CRYS_SST_AES(TST_AESKeyHandle1,
                                     TST_SessionId,
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_IVCounter,       
                                     CRYS_AES_Encrypt, 
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_OperationMode,       
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataIn,        
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataInSize,         
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataOut,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_AES - Encrypt",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Decrypt the block of data using key #2 */
            /* In case using CTR we use Encrypt again */
            /*----------------------------------------*/
            if (TST_ATP_SpecialDataOpAESTestData[TST_index].TST_OperationMode == CRYS_AES_CTR_mode)
                TST_CRYS_AES_EncryptMode = CRYS_AES_Encrypt;
            else
                TST_CRYS_AES_EncryptMode = CRYS_AES_Decrypt;

            TST_Status = CRYS_SST_AES(TST_AESKeyHandle2,
                                     TST_SessionId,
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_IVCounter,       
                                     TST_CRYS_AES_EncryptMode, 
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_OperationMode,       
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataOut,        
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataInSize,         
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataOutDecrypt,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_AES - Decrypt",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Compare the decrypted data to original one */
      /*--------------------------------------------*/
         if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataIn,
                TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataOutDecrypt,
                TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataInSize))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Decrypted data",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Delete the AES keys */
            /*---------------------*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_AESKeyHandle1,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - AES key #1",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_AESKeyHandle2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - AES key #2",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the authentication */
            /*--------------------------*/
            TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);
            
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Delete the authenticator */
            /*--------------------------*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                                TST_AuthHandle);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_SpecialDataOpAESTestData[TST_index].TST_Name,
                          TST_MasterTestName);

        }/*End of TST_index "for loop" */
    }/*End of TST_HandleType "for loop" */
    return TST_Status;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}/* End of SST_TST_ATP_SpecialDataOpAES */
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_SpecialDataOpDES        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of a DES symmetric key.
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd.
 *    5.  Open the authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new DES #1 key by calling: SST_DESKeyGenerate.
 *    8.  Read the generated DES key #1 by calling: SST_DESKeyRead.
 *    9.  Insert a DES #2 key to the SST by calling: SST_DESKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted DES key #2 by calling: SST_DESKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Encrypt plain text by using DES key #1 and calling: CRYS_SST_DES.
 *    13.  Decrypt the received cipher text using DES key #2 by calling: CRYS_SST_DES and compare to the original plain text.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the DES keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SST_TST_ATP_SpecialDataOpDES ( void )
{ 
   /********* TST Variables Definitions ************/
    int                         TST_index,TST_HandleType;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_SpecialDataOpDES";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle,TST_DESKeyHandle1,TST_DESKeyHandle2;
    SSTDataType_t               TST_DESKeyData = TST_DESKEY_OBJECT;
  SSTHandle_t                  TST_AuthDefaultHandle;
  DxError_t                TST_Status = DX_FAILURE;
    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_SpecialDataOpDES Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_SST_TST_ATP_SpecialDataOpDESTests ; TST_index++) /*To run on all test vectors*/
        {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
                TST_DESKeyHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DESKeyHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = TST_TEST_DEFINED_HENDLE;
                TST_DESKeyHandle1.objId = TST_TEST_DEFINED_HENDLE_2;
                TST_DESKeyHandle2.objId = TST_TEST_DEFINED_HENDLE_3;
            }

            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,"\n"));

            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new password authenticator */
            /*-------------------------------------*/
            TST_AuthDefaultHandle.objDigest = 0;
      TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
            TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                        TST_SessionId,
                                                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Password,
                                                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_PasswordSizeInBytes,
                                                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_MaxNumOfTrials,
                                                        TST_AuthDefaultHandle,
                                                        &TST_AuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


      /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*----------------------------------*/
                TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                                   TST_AuthHandle,
                                                   TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Password,
                                                   TST_ATP_SpecialDataOpDESTestData[TST_index].TST_PasswordSizeInBytes,
                                                   TST_NO_CHALLENGE,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new DES key #1 */
            /*-------------------------*/
            TST_Status = SST_DESKeyGenerate(TST_TransactionId,
                                           TST_SessionId,
                                           TST_AuthHandle,                                
                                           TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType1,
                                           TST_DESKeyData,
                                           &TST_DESKeyHandle1,
                                           TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyGenerate",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify the type of DES key #1 */
            /*-------------------------------*/
            TST_Status = SST_DESKeyRead(TST_SessionId,
                                       TST_DESKeyHandle1,   
                                       TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKey2,
                                       &TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyRead - Get key type",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            if (TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType2 != TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType1)
                TST_Status = DX_FALSE;

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Validate key type - DES",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert DES Key #2 */
            /*-------------------*/
            TST_Status = SST_DESKeyInsert(TST_TransactionId,
                                         TST_SessionId,
                                         TST_AuthHandle,                                                               
                                         TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKey2,
                                         TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType2,
                                         TST_DESKeyData,
                                         &TST_DESKeyHandle2,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyInsert - Key #2",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Read DES key #2 */
            /*-----------------*/
            TST_Status = SST_DESKeyRead(TST_SessionId,
                                       TST_DESKeyHandle2,   
                                       TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyTemp,
                                       &TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyTypeTemp,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyRead #2",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Compare the retrieved key to inserted one */
      /*-------------------------------------------*/
         if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKey2,
                TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyTemp,
                TST_ATP_SpecialDataOpDESTestData[TST_index].TST_KeySizeInBytes))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - keys",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Encrypt a block of data using key #1 */
            /*--------------------------------------*/
            TST_Status = CRYS_SST_DES(TST_DESKeyHandle1,
                                     TST_SessionId,
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_IVCounter,       
                                     CRYS_DES_Encrypt, 
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_OperationMode,       
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataIn,        
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataInSize,         
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataOut,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_DES - Encrypt",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Decrypt the block of data using key #2 */
            /*----------------------------------------*/
            TST_Status = CRYS_SST_DES(TST_DESKeyHandle2,
                                     TST_SessionId,
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_IVCounter,       
                                     CRYS_DES_Decrypt, 
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_OperationMode,       
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataOut,        
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataInSize,         
                                     TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataOutDecrypt,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_DES - Decrypt",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Compare the decrypted data to original one */
      /*--------------------------------------------*/
         if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataIn,
                TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataOutDecrypt,
                TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataInSize))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Decrypted data",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Delete the DES keys */
            /*---------------------*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_DESKeyHandle1,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - DES key #1",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_DESKeyHandle2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - DES key #2",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Close the authentication */
            /*--------------------------*/
            TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);
            
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the authenticator */
            /*--------------------------*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                                TST_AuthHandle);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


        }/*End of TST_index "for loop" */
    }/*End of TST_HandleType "for loop" */
    return TST_Status;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}/* End of SST_TST_ATP_SpecialDataOpDES */
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_SpecialDataOpHMAC        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of a HMAC key.
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionClose.
 *    5.  Open the authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new HMAC #1 key by calling: SST_HMACKeyGenerate.
 *    8.  Read the generated HMAC key #1 by calling: SST_HMACKeyRead.
 *    9.  Insert a HMAC #2 key to the SST by calling: SST_HMACKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted HMAC key #2 by calling: SST_HMACKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Hash plain text by using HMAC key #1 and calling: CRYS_SST_HMAC.
 *    13.  Hash the received cipher text using HMAC key #2 by calling: CRYS_SST_HMAC and compare to the original hash result.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the HMAC keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.                             
 *
 *******************************************************************************/    
DxError_t SST_TST_ATP_SpecialDataOpHMAC ( void )
{ 
   /********* TST Variables Definitions ************/
    int                         TST_index,TST_HandleType;
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_SpecialDataOpHMAC";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle,TST_HMACKeyHandle1,TST_HMACKeyHandle2;
    SSTDataType_t               TST_HMACKeyData = TST_HMACKEY_OBJECT;
  SSTHandle_t                 TST_AuthDefaultHandle;
  DxError_t                TST_Status = DX_FAILURE;
    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_SpecialDataOpHMAC Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_SST_TST_ATP_SpecialDataOpHMACTests ; TST_index++) /*To run on all test vectors*/
        {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
                TST_HMACKeyHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_HMACKeyHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = TST_TEST_DEFINED_HENDLE;
                TST_HMACKeyHandle1.objId = TST_TEST_DEFINED_HENDLE_2;
                TST_HMACKeyHandle2.objId = TST_TEST_DEFINED_HENDLE_3;
            }

            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,"\n"));

            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new password authenticator */
            /*-------------------------------------*/
            TST_AuthDefaultHandle.objDigest = 0;
      TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
            TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                        TST_SessionId,
                                                        TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Password,
                                                        TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_PasswordSizeInBytes,
                                                        TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_MaxNumOfTrials,
                                                        TST_AuthDefaultHandle,
                                                        &TST_AuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


      /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*----------------------------------*/
                TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                                   TST_AuthHandle,
                                                   TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Password,
                                                   TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_PasswordSizeInBytes,
                                                   TST_NO_CHALLENGE,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new HMAC key #1 */
            /*-------------------------*/
            TST_Status = SST_HMACKeyGenerate(TST_TransactionId,
                                           TST_SessionId,
                                           TST_AuthHandle,                                
                                           TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey1Size,
                                           TST_HMACKeyData,
                                           &TST_HMACKeyHandle1,
                                           TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_HMACKeyGenerate",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Read HMAC key #1 */
            /*-----------------*/
            TST_Status = SST_HMACKeyRead(TST_SessionId,
                                       TST_HMACKeyHandle1,   
                                       TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2,
                                       &TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2Size,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_HMACKeyRead #1",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert HMAC Key #2 */
            /*--------------------*/
            TST_Status = SST_HMACKeyInsert(TST_TransactionId,
                                         TST_SessionId,
                                         TST_AuthHandle,                                                               
                                         TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2,
                                         TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2Size,
                                         TST_HMACKeyData,
                                         &TST_HMACKeyHandle2,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_HMACKeyInsert - Key #2",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Read HMAC key #2 */
            /*-----------------*/
            TST_Status = SST_HMACKeyRead(TST_SessionId,
                                       TST_HMACKeyHandle2,   
                                       TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTemp,
                                       &TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTempSize,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_HMACKeyRead #2",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Compare the retrieved key to inserted one */
      /*-------------------------------------------*/
       if(TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2Size ==
          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTempSize)

         TST_Status = TESTPASS; /*Data Buffers are the same*/
        else
         TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Compare key size - HMACKey2",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


         if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKey2,
                TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTemp,
                TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HMACKeyTempSize))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - keys",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* HASH a block of data using key #1 */
            /*-----------------------------------*/
            TST_Status = CRYS_SST_HMAC(TST_HMACKeyHandle1,
                                     TST_SessionId,     
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_OperationMode,        
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataIn,        
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataInSize,         
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataHMAC_Result1,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_HMAC - Key1",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* HASH a block of data using key #2 */
            /*-----------------------------------*/
            TST_Status = CRYS_SST_HMAC(TST_HMACKeyHandle2,
                                     TST_SessionId,     
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_OperationMode,        
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataIn,        
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataInSize,         
                                     TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataHMAC_Result2,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_HMAC - Key2",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Compare the hashed results */
      /*----------------------------*/
         if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataHMAC_Result1,
                TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_DataHMAC_Result2,
                TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_HASHSize))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Decrypted data",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Delete the HMAC keys */
            /*---------------------*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_HMACKeyHandle1,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - HMAC key #1",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_HMACKeyHandle2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - HMAC key #2",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the authentication */
            /*--------------------------*/
            TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);
            
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Delete the authenticator */
            /*--------------------------*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                                TST_AuthHandle);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_SpecialDataOpHMACTestData[TST_index].TST_Name,
                          TST_MasterTestName);


        }/*End of TST_index "for loop" */
    }/*End of TST_HandleType "for loop" */
    return TST_Status;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}/* End of SST_TST_ATP_SpecialDataOpHMAC */
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_SpecialDataOpRSA      
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of a RSA asymmetric key.
 *  
 * Algorithm:       
 *     1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
 *     2.  Create a new session by calling: SST_SessionCreate.
 *     3.  Open a transaction by calling: SST_TransactionStart.
 *     4.  Create a public key authenticator by calling: SST_AuthenticatorPubKeyRSACreate.
 *     5.  Open the authenticator by calling:
 *     i.  SST_AuthenticatorChallengeGet 
 *         ii.  CRYS_RSA_PSS_Sign
 *         iii.  SST_AuthenticationOpen.
 *     6.  Close the transaction by calling: SST_TransactionClose.
 *     7.  Open the authenticator by calling: SST_AuthenticationOpen.
 *     8.  Create a new RSA #1 key by calling: SST_RSAKeyGenerate.
 *     9.  Create a new RSA #2 key by calling: SST_CRTRSAKeyGenerate.
 *     10.  Read the generated RSA key #1 by calling: 
 *          i.  SST_RSAPublicKeyRead.
 *          ii.  SST_RSAPrivateKeyRead.
 *     11.  Read the generated RSA key #2 by calling: 
 *          i.  SST_CRTRSAPublicKeyRead.
 *          ii.  SST_CRTRSAPrivateKeyRead.
 *     12.  Insert an RSA #3 key to the SST by calling:
 *          i.   SST_RSAPublicKeyInsert. 
 *          ii.  SST_RSAPrivateKeyInsert
 *          Using the data received by reading the SST key #1
 *     13.  Insert an RSA #4 key to the SST by calling:
 *          i.   SST_CRTRSAPublicKeyInsert.
 *          ii.  SST_CRTRSAPrivateKeyInsert
 *          Using the data received by reading the SST key #2
 *     14.  Insert RSA #5 key to the SST by calling: SST_RSAPairKeyInsert. Externally generated key pair
 *     15.  Insert RSA #6 (CRT) key to the SST by calling SST_CRTRSAPairKeyInsert. Externally generated key pair
 *     16.  Close the transaction by calling: SST_TransactionClose.
 *     17.  Sign a plain text by using RSA key #1 and calling: CRYS_SST_RSA_PKCS1v15_Sign.
 *     18.  Verify the signature using RSA key #3 and calling: CRYS_SST_RSA_PKCS1v15_Verify.
 *     19.  Sign a plain text by using RSA key #2 and calling: CRYS_SST_RSA_PSS_Sign.
 *     20.  Verify the signature using RSA key #4 and calling: CRYS_SST_RSA_PSS_Verify.
 *     21.  Sign a plain text by using RSA key #5 and calling: CRYS_SST_RSA_PKCS1v15_Sign.
 *     22.  Verify the signature using RSA key #6 and calling: CRYS_SST_RSA_PKCS1v15_Verify.
 *     23.  Sign a plain text by using RSA key #5 and calling: CRYS_SST_RSA_PSS_Sign.
 *     24.  Verify the signature using RSA key #6 and calling: CRYS_SST_RSA_PSS_Verify.
 *     25.  Open a transaction by calling: SST_TransactionStart.
 *     26.  Delete the RSA keys (one by one) by calling: SST_DataDelete.
 *     27.  Close the authenticator by calling: SST_AuthenticationClose.
 *     28.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *     29.  Close the transaction by calling: SST_TransactionClose.
 *     30.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SST_TST_ATP_SpecialDataOpRSA ( void )
{ 
   /********* TST Variables Definitions ************/
    int                                         TST_index,TST_HandleType;
    char                                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_SpecialDataOpRSA";
    SSTSessionId_t                              TST_SessionId; 
    SSTTxnId_t                                  TST_TransactionId;
    SSTChallengeId_t                            TST_ChallengeId;
    SSTHandle_t                                 TST_AuthHandle;
    SSTHandle_t                                 TST_RSAKeyHandle1,TST_RSAKeyHandle2,TST_RSAKeyHandle5,TST_RSAKeyHandle6;
    SSTHandle_t                                 TST_RSAKeyHandlePrivate3,TST_RSAKeyHandlePublic3,TST_RSAKeyHandlePrivate4,TST_RSAKeyHandlePublic4;
    SSTDataType_t                               TST_RSAKeyData = TST_RSAKEY_OBJECT;
    CRYS_RSAPrivUserContext_t                  TST_UserPrivateContext;
    CRYS_RSAPubUserContext_t                  TST_UserPublicContext;
    static CRYS_RSAUserPrivKey_t                TST_CRYS_RSAUserPrivKey;
    static CRYS_RSAPrivUserContext_t            TST_CRYS_RSAPrivUserContext;
    static CRYS_SST_RSA_pair_keys_container_t   TST_pairKeysCont;
  DxError_t                                TST_Status = DX_FAILURE;

    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_SpecialDataOpRSA Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_SST_TST_ATP_SpecialDataOpRSATests ; TST_index++) /*To run on all test vectors*/
        {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
                TST_RSAKeyHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_RSAKeyHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_RSAKeyHandlePrivate3.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_RSAKeyHandlePublic3.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_RSAKeyHandlePrivate4.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_RSAKeyHandlePublic4.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_RSAKeyHandle5.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_RSAKeyHandle6.objId = SST_HANDLE_RANDOM_GENERATE;
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = TST_TEST_DEFINED_HENDLE;
                TST_RSAKeyHandle1.objId = TST_TEST_DEFINED_HENDLE_2;
                TST_RSAKeyHandle2.objId = TST_TEST_DEFINED_HENDLE_3;
                TST_RSAKeyHandlePrivate3.objId = TST_TEST_DEFINED_HENDLE_4;
                TST_RSAKeyHandlePublic3.objId = TST_TEST_DEFINED_HENDLE_5;
                TST_RSAKeyHandlePrivate4.objId = TST_TEST_DEFINED_HENDLE_6;
                TST_RSAKeyHandlePublic4.objId = TST_TEST_DEFINED_HENDLE_7;
                TST_RSAKeyHandle5.objId = TST_TEST_DEFINED_HENDLE_8;
                TST_RSAKeyHandle6.objId = TST_TEST_DEFINED_HENDLE_9;
            }

            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,"\n"));

            /* Build the Private Key for CRYS usage */
            /*--------------------------------------*/
            TST_Status = CRYS_RSA_Build_PrivKey(&TST_CRYS_RSAUserPrivKey,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D,
                                               (DxUint16_t)TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChalengeKeySizeInBytes,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E,
                                               (DxUint16_t)TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChalengeKeyESizeInBytes,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N,
                                               (DxUint16_t)TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChalengeKeySizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_Build_PrivKey",
                    TST_ATP_RsaAuthObjectTestData[TST_index].TST_Name,
                    TST_MasterTestName);




            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Create a new RSA authenticator */
            /*--------------------------------*/
            TST_Status = SST_AuthenticatorPubKeyRSACreate(TST_TransactionId,
                                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N,
                                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E,
                                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChalengeKeyESizeInBytes,
                                                      &TST_AuthHandle,
                                                      TST_Workspace,
                                                      TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPubKeyRSACreate",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the authentication */
            /*-------------------------*/
            /* Get the challenge*/
            TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChallengeBuff,
                                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChallengeBuffSize,  
                                                      &TST_ChallengeId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Sign the Challenge buffer */
           TST_Status = CRYS_RSA_PSS_Sign(&TST_CRYS_RSAPrivUserContext,
                                               &TST_CRYS_RSAUserPrivKey,
                                               CRYS_RSA_HASH_SHA1_mode,
                         CRYS_PKCS1_MGF1,
                         20,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChallengeBuff,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChallengeBuffSize,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SignedChallengeBuff,
                                               (DxUint16_t*)&TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SignedChallengeBuffSize);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_PSS_Sign",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the authenticator */
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SignedChallengeBuff,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SignedChallengeBuffSize,
                                               TST_ChallengeId,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);
                                               

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);
    

      /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new RSA key #1 */
            /*-------------------------*/
            TST_Status = SST_RSAKeyGenerate(TST_TransactionId,
                                           TST_SessionId,
                                           TST_AuthHandle,                                
                                           TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key1SizeInBytes,
                                           TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E1,
                                           TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E1SizeInBytes,
                                           TST_RSAKeyData,
                                           &TST_RSAKeyHandle1,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAKeyGenerate - Key1",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new RSA key #2 */
            /*-------------------------*/
            TST_Status = SST_CRTRSAKeyGenerate(TST_TransactionId,
                                              TST_SessionId,
                                              TST_AuthHandle,                                
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key1SizeInBytes,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E1,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E1SizeInBytes,
                                              TST_RSAKeyData,
                                              &TST_RSAKeyHandle2,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);


      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAKeyGenerate - Key2",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Read RSA key #1 for key 3 using two calls */
            /*-------------------------------------------*/
            TST_Status = SST_RSAPublicKeyRead(TST_SessionId,  
                                             TST_RSAKeyHandle1, 
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3,
                                             &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3SizeInBytes,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E3,
                                             &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E3SizeInBytes,
                                             TST_Workspace,
                                             TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPublicKeyRead #1",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_RSAPrivateKeyRead(TST_SessionId,  
                                              TST_RSAKeyHandle1, 
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D3,
                                              &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D3SizeInBytes,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3,
                                              &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3SizeInBytes,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);


            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPrivateKeyRead #1",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Read RSA key #2 for key 4 using two calls */
            /*-------------------------------------------*/
            TST_Status = SST_CRTRSAPublicKeyRead(TST_SessionId,
                                                     TST_RSAKeyHandle2,
                                                     TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N4,
                                                     &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N4SizeInBytes,
                                                     TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E4,
                                                     &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E4SizeInBytes,
                                                     TST_Workspace,
                                                     TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPublicKeyRead #2",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


             TST_Status = SST_CRTRSAPrivateKeyRead(TST_SessionId,
                                                       TST_RSAKeyHandle2,
                                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P4,
                                                       &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P4SizeInBytes,
                                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q4,
                                                       &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q4SizeInBytes,
                                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP4,
                                                       &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP4SizeInBytes,
                                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ4,
                                                       &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ4SizeInBytes,
                                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv4,
                                                       &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv4SizeInBytes,
                                                       TST_Workspace,
                                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPrivateKeyRead #2",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert RSA Key #3 */
            /*--------------------*/
            TST_Status = SST_RSAPublicKeyInsert (TST_TransactionId,
                                                TST_SessionId,                          
                                                TST_AuthHandle, 
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3SizeInBytes,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E3,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E3SizeInBytes,
                                                TST_RSAKeyData,
                                                &TST_RSAKeyHandlePublic3,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPublicKeyInsert - Key #3",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_RSAPrivateKeyInsert(TST_TransactionId,
                                                TST_SessionId,                          
                                                TST_AuthHandle,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D3,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D3SizeInBytes,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3SizeInBytes,
                                                TST_RSAKeyData,
                                                &TST_RSAKeyHandlePrivate3,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);


            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPrivateKeyInsert - Key #3",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert RSA Key #4 */
            /*-------------------*/
            TST_Status = SST_CRTRSAPublicKeyInsert(TST_TransactionId,
                                                  TST_SessionId,
                                                  TST_AuthHandle, 
                                                  TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N4,
                                                  TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N4SizeInBytes,
                                                  TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E4,
                                                  TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E4SizeInBytes,
                                                  TST_RSAKeyData,
                                                  &TST_RSAKeyHandlePublic4,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPublicKeyInsert - Key #4",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_CRTRSAPrivateKeyInsert(TST_TransactionId,
                                                    TST_SessionId,
                                                    TST_AuthHandle, 
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P4,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P4SizeInBytes,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q4,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q4SizeInBytes,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP4,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP4SizeInBytes,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ4,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ4SizeInBytes,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv4,
                                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv4SizeInBytes,
                                                    TST_RSAKeyData,
                                                    &TST_RSAKeyHandlePrivate4,
                                                    TST_Workspace,
                                                    TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPrivateKeyInsert - Key #4",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert key 5 regular - externally generated */
            /*---------------------------------------------*/
            TST_Status = SST_RSAPairKeyInsert(TST_TransactionId,
                                             TST_SessionId,                          
                                             TST_AuthHandle,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N5,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D5,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E5,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E5SizeInBytes,
                                             TST_RSAKeyData,
                                             &TST_RSAKeyHandle5,
                                             TST_Workspace,
                                             TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPairKeyInsert - Key #5",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);
  


            /* Insert key 6 CRT (same as key 5) - externally generated */
            /*---------------------------------------------------------*/
            TST_Status = SST_CRTRSAPairKeyInsert(TST_TransactionId,
                                                TST_SessionId,
                                                TST_AuthHandle, 
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N5,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E5,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E5SizeInBytes,
                        TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P5,
                                                (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q5,
                                                (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP5,
                                                (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ5,
                                                (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv5,
                                                (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                                TST_RSAKeyData,
                                                &TST_RSAKeyHandle6,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPairKeyInsert - Key #6",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);
  


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Sign a block of data using key #1 PKCS1_v1.5 */
            /*----------------------------------------------*/
            TST_Status = CRYS_SST_RSA_PKCS1v15_Sign(TST_RSAKeyHandle1,
                                                   TST_SessionId,
                                                   &TST_UserPrivateContext,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,        
                                                   &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOutSize,
                                                   &TST_pairKeysCont,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PKCS1v15_Sign - Key1",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify the signature of data using key #3 PKCS1_v1.5 */
            /*------------------------------------------------------*/
            TST_Status = CRYS_SST_RSA_PKCS1v15_Verify(TST_RSAKeyHandlePublic3,
                                                   TST_SessionId,
                                                   &TST_UserPublicContext,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                                   &TST_pairKeysCont,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PKCS1v15_Verify - Key3",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Sign a block of data using key #2 PKCS1_v2.1 */
            /*----------------------------------------------*/
            TST_Status = CRYS_SST_RSA_PSS_Sign(TST_RSAKeyHandle2,
                                              TST_SessionId,
                                              &TST_UserPrivateContext,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                              CRYS_PKCS1_MGF1,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SaltLengthSign,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,        
                                              &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOutSize,
                                              &TST_pairKeysCont,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PSS_Sign - Key2",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify the signature of data using key #4 PKCS1_v2.1 */
            /*------------------------------------------------------*/
            TST_Status = CRYS_SST_RSA_PSS_Verify(TST_RSAKeyHandlePublic4,
                                                TST_SessionId,
                                                &TST_UserPublicContext,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                                CRYS_PKCS1_MGF1,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SaltLengthVerify,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                                &TST_pairKeysCont,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PSS_Verify - Key4",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Sign a block of data using key #5 PKCS1_v1.5 */
            /*----------------------------------------------*/
            TST_Status = CRYS_SST_RSA_PKCS1v15_Sign(TST_RSAKeyHandle5,
                                                   TST_SessionId,
                                                   &TST_UserPrivateContext,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,        
                                                   &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOutSize,
                                                   &TST_pairKeysCont,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PKCS1v15_Sign - Key5",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify the signature of data using key #6 PKCS1_v1.5 */
            /*------------------------------------------------------*/
            TST_Status = CRYS_SST_RSA_PKCS1v15_Verify(TST_RSAKeyHandle6,
                                                     TST_SessionId,
                                                     &TST_UserPublicContext,
                                                     TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                                     TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                                     TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                                     TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                                     &TST_pairKeysCont,
                                                     TST_Workspace,
                                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PKCS1v15_Verify - Key6",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Sign a block of data using key #6 PKCS1_v2.1 */
            /*----------------------------------------------*/
            TST_Status = CRYS_SST_RSA_PSS_Sign(TST_RSAKeyHandle6,
                                              TST_SessionId,
                                              &TST_UserPrivateContext,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                              CRYS_PKCS1_MGF1,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SaltLengthSign,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,        
                                              &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOutSize,
                                              &TST_pairKeysCont,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PSS_Sign - Key6",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify the signature of data using key #5 PKCS1_v2.1 */
            /*------------------------------------------------------*/
            TST_Status = CRYS_SST_RSA_PSS_Verify(TST_RSAKeyHandle5,
                                                TST_SessionId,
                                                &TST_UserPublicContext,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                                CRYS_PKCS1_MGF1,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SaltLengthVerify,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                                TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                                &TST_pairKeysCont,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PSS_Verify - Key5",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Delete the RSA keys */
            /*---------------------*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_RSAKeyHandle1,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key #1",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_RSAKeyHandle2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key #2",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_RSAKeyHandlePrivate3,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key Private #3",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_RSAKeyHandlePublic3,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key public #3",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_RSAKeyHandlePrivate4,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key Private #4",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_RSAKeyHandlePublic4,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key public #4",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_RSAKeyHandle5,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key #5",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            TST_Status = SST_DataDelete(TST_TransactionId,
                                       TST_SessionId,  
                                       TST_RSAKeyHandle6,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key #6",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the authentication */
            /*--------------------------*/
            TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);
            
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the authenticator */
            /*--------------------------*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                                TST_AuthHandle);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


        }/*End of TST_index "for loop" */
    }/*End of TST_HandleType "for loop" */
    return TST_Status;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}/* End of SST_TST_ATP_SpecialDataOpRSA */
/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

#endif

